#!/bin/sh

F_product_config_pre_check()
{
    F_debug_log "F_product_config_pre_check"
    local DataPartMountPoint=`F_ini_get $PACKAGE_CONFIG Partition DataPartMountPoint`
    if [ ${DataPartMountPoint} = "" ];then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Config DataPartMountPoint is not set in section Partition"
        return 1
    fi

    local DataPartMountPoint_size=`du -s $DataPartMountPoint|awk -F' ' '{print $1}'`
    F_debug_log "Need $DataPartMountPoint_size to Backup $DataPartMountPoint: avaiable_backup_dst_space: $avaiable_backup_dst_space"
    if [ $avaiable_backup_dst_space -lt $DataPartMountPoint_size ];then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Avaiable backup space size is less than the size of $DataPartMountPoint"
        return 1
    fi
    avaiable_backup_dst_space=`expr $avaiable_backup_dst_space - $DataPartMountPoint_size`

    return 0
}

F_product_config_pre_apply()
{
    F_debug_log "Backup DDD Data"
    local DataPartMountPoint=`F_ini_get $PACKAGE_CONFIG Partition DataPartMountPoint`

    F_debug_log "DataPartMountPoint: $DataPartMountPoint"
    F_debug_log "DDDDataBackupFile: $DDDDataBackupFile"

    [ -e $DDDDataBackupFile ] && /usr/bin/rm $DDDDataBackupFile
    /usr/bin/tar cf $DDDDataBackupFile $DataPartMountPoint/Pixiebob --exclude=$DataPartMountPoint/Pixiebob/Server/logs 2>&1
    TAR_RV=$?
    if [ $TAR_RV -eq 1 ]; then
        F_debug_log "$FUNCNAME" "`expr $LINENO - 1`" "Source file being changed while archived, should have no impact."
    elif [ $TAR_RV -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to backup $DataPartMountPoint. Stop Upgrade ($TAR_RV)"
        return 1
    fi
    local RestoreConfigs=`F_ini_get_section ${PACKAGE_CONFIG} "RestoreConfigs" | grep -v '#'`
    if [ -n "$RestoreConfigs" ];then
        F_debug_log "Copy Config for restore"
        eval $RestoreConfigs
        #Ini_Config-> FilePath|Section|Key1:Key2:Key3...
        for configLine in $Ini_Config ; do
            local configPath=`echo $configLine |cut -d '|' -f 1`
            tar uf $DDDConfigBackupFile $configPath
        done
    fi

    return 0
}

F_product_config_post_apply()
{
    F_debug_log "Restore Config"
    /usr/bin/mkdir -p $backup_dst/ddd_backup/config
    if [ -e $DDDConfigBackupFile ]; then
        tar xf $DDDConfigBackupFile -C $backup_dst/ddd_backup/config
        local RestoreConfigs=`F_ini_get_section ${PACKAGE_CONFIG} "RestoreConfigs" | grep -v '#'`
        F_debug_log "Copy Config for restore"
        eval $RestoreConfigs
        #FilePath|Section|Key1:Key2:Key3...
        for configLine in $Ini_Config ; do
            F_debug_log "$configLine"
            local configPath=`echo $configLine |cut -d '|' -f 1`
            local configSection=`echo $configLine |cut -d '|' -f 2`
            local configKeys=`echo $configLine |cut -d '|' -f 3`
            IFS=': ' read -r -a configKeys <<< "$configKeys"
            for iniConfig in "${configKeys[@]}" ; do
                local valueBackup=`F_ddd_ini_get ${backup_dst}/ddd_backup/config/${configPath} "$configSection" "$iniConfig"`
                if [ "$valueBackup" != "" ]; then
                    F_ddd_ini_set ${configPath} "$configSection" "$iniConfig" "$valueBackup"
                    F_debug_log "restore ${configPath} \"$configSection\" \"$iniConfig\" to value \"$valueBackup\""
                else
                    F_debug_log "New config ${configPath} \"$configSection\" \"$iniConfig\", skip."
                fi
            done
        done
        if [ -e ${backup_dst}/ddd_backup/config ]; then
            /usr/bin/rm -rf ${backup_dst}/ddd_backup/config
        fi
    fi

    if [ -e ${SYS_ROOT_DIR}/opt/TrendMicro/Pixiebob/Server/api/data/ga_cr.ini ]; then
        VAL=`grep Version ${SYS_ROOT_DIR}/opt/TrendMicro/Pixiebob/Server/api/data/ga_cr.ini`
        RET=$?
        if [ "${RET}" -ne "0" ]; then
            sed -i 's/\[Value\]/Version = 0\n\[Value\]/g' ${SYS_ROOT_DIR}/opt/TrendMicro/Pixiebob/Server/api/data/ga_cr.ini
        fi
    fi

    if [ -e ${SYS_ROOT_DIR}/opt/TrendMicro/Pixiebob/Server/api/data/ga_lr.ini ]; then
        VAL=`grep CR_Version ${SYS_ROOT_DIR}/opt/TrendMicro/Pixiebob/Server/api/data/ga_lr.ini`
        RET=$?
        if [ "${RET}" -ne "0" ]; then
            sed -i 's/\[Value\]/CR_Version = 0\n\[Value\]/g' ${SYS_ROOT_DIR}/opt/TrendMicro/Pixiebob/Server/api/data/ga_lr.ini
        fi
    fi

    return 0
}

F_product_config_pre_apply_recovery()
{
    F_debug_log "Remove data backup file"
    if [ -e $DDDDataBackupFile ]; then
        /usr/bin/rm $DDDDataBackupFile
    fi
    if [ -e $DDDConfigBackupFile ]; then
        /usr/bin/rm $DDDConfigBackupFile
    fi
    if [ -e ${backup_dst}/ddd_backup/config ]; then
        /usr/bin/rm -rf ${backup_dst}/ddd_backup/config
    fi

    return 0
}

F_product_config_post_apply_recovery()
{
    F_debug_log "Restore data"
    /usr/bin/tar xf $DDDDataBackupFile -C /
    if [ $? -ne 0 ]; then
        F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Failed to restore $DataPartMountPoint."
    fi
    return 0
}
